function im_acf_init() {
if( function_exists('acf_register_block') ) {
 acf_register_block(array(
			'name'				=> 'image-with-text',
			'title'				=> __('Image With Content'),
			'description'       => __('A custom content with iframe on a page block.'),
			'render_callback'	=> 'im_acf_block_render_callback',
			//'category'			=> 'formatting',
			'category'			=> 'common-blocks',
			'icon'				=> 'star-empty',
            'mode'              => 'preview',
            'supports'          => [
                'align'			    => false,
                'anchor'		    => true,
                'customClassName'	=> true,
                'jsx' 			    => true,
			],
			'example'  => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => array(
                        '_is_preview'   => 'true'
                    )
                )
            ),
		));
			}
}

function im_acf_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);

    if( file_exists( get_theme_file_path("/modules/content-{$slug}.php") ) ) {
		include( get_theme_file_path("/modules/content-{$slug}.php") );
	}
}